@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Backend address of an application gateway.
 * @property fqdn Fully qualified domain name (FQDN).
 * @property ipAddress IP address.
 */
public data class ApplicationGatewayBackendAddressResponse(
    public val fqdn: String? = null,
    public val ipAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayBackendAddressResponse): ApplicationGatewayBackendAddressResponse = ApplicationGatewayBackendAddressResponse(
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
