@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Application gateway BackendHealthHttp settings.
 * @property backendHttpSettings Reference to an ApplicationGatewayBackendHttpSettings resource.
 * @property servers List of ApplicationGatewayBackendHealthServer resources.
 */
public data class ApplicationGatewayBackendHealthHttpSettingsResponse(
    public val backendHttpSettings: ApplicationGatewayBackendHttpSettingsResponse? = null,
    public val servers: List<ApplicationGatewayBackendHealthServerResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayBackendHealthHttpSettingsResponse): ApplicationGatewayBackendHealthHttpSettingsResponse =
            ApplicationGatewayBackendHealthHttpSettingsResponse(
                backendHttpSettings = javaType.backendHttpSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendHttpSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                servers = javaType.servers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendHealthServerResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
