@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Backend address pool settings of an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hostName Server name indication to be sent to the backend servers for Tls protocol.
 * @property id Resource ID.
 * @property name Name of the backend settings that is unique within an Application Gateway.
 * @property pickHostNameFromBackendAddress Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.
 * @property port The destination port on the backend.
 * @property probe Probe resource of an application gateway.
 * @property protocol The protocol used to communicate with the backend.
 * @property provisioningState The provisioning state of the backend HTTP settings resource.
 * @property timeout Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
 * @property trustedRootCertificates Array of references to application gateway trusted root certificates.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayBackendSettingsResponse(
    public val etag: String,
    public val hostName: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val pickHostNameFromBackendAddress: Boolean? = null,
    public val port: Int? = null,
    public val probe: SubResourceResponse? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val timeout: Int? = null,
    public val trustedRootCertificates: List<SubResourceResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayBackendSettingsResponse): ApplicationGatewayBackendSettingsResponse = ApplicationGatewayBackendSettingsResponse(
            etag = javaType.etag(),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            pickHostNameFromBackendAddress = javaType.pickHostNameFromBackendAddress().map({ args0 ->
                args0
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            probe = javaType.probe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            trustedRootCertificates = javaType.trustedRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
