@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Application gateway client authentication configuration.
 * @property verifyClientCertIssuerDN Verify client certificate issuer name on the application gateway.
 * @property verifyClientRevocation Verify client certificate revocation status.
 */
public data class ApplicationGatewayClientAuthConfigurationResponse(
    public val verifyClientCertIssuerDN: Boolean? = null,
    public val verifyClientRevocation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayClientAuthConfigurationResponse): ApplicationGatewayClientAuthConfigurationResponse =
            ApplicationGatewayClientAuthConfigurationResponse(
                verifyClientCertIssuerDN = javaType.verifyClientCertIssuerDN().map({ args0 -> args0 }).orElse(null),
                verifyClientRevocation = javaType.verifyClientRevocation().map({ args0 -> args0 }).orElse(null),
            )
    }
}
