@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
 * @property drainTimeoutInSec The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
 * @property enabled Whether connection draining is enabled or not.
 */
public data class ApplicationGatewayConnectionDrainingResponse(
    public val drainTimeoutInSec: Int,
    public val enabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayConnectionDrainingResponse): ApplicationGatewayConnectionDrainingResponse = ApplicationGatewayConnectionDrainingResponse(
            drainTimeoutInSec = javaType.drainTimeoutInSec(),
            enabled = javaType.enabled(),
        )
    }
}
