@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom error of an application gateway.
 * @property customErrorPageUrl Error page URL of the application gateway custom error.
 * @property statusCode Status code of the application gateway custom error.
 */
public data class ApplicationGatewayCustomErrorResponse(
    public val customErrorPageUrl: String? = null,
    public val statusCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayCustomErrorResponse): ApplicationGatewayCustomErrorResponse = ApplicationGatewayCustomErrorResponse(
            customErrorPageUrl = javaType.customErrorPageUrl().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
