@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Allows to disable rules within a rule group or an entire rule group.
 * @property ruleGroupName The name of the rule group that will be disabled.
 * @property rules The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
 */
public data class ApplicationGatewayFirewallDisabledRuleGroupResponse(
    public val ruleGroupName: String,
    public val rules: List<Int>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayFirewallDisabledRuleGroupResponse): ApplicationGatewayFirewallDisabledRuleGroupResponse =
            ApplicationGatewayFirewallDisabledRuleGroupResponse(
                ruleGroupName = javaType.ruleGroupName(),
                rules = javaType.rules().map({ args0 -> args0 }),
            )
    }
}
