@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 * @property matchVariable The variable to be excluded.
 * @property selector When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
 * @property selectorMatchOperator When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
 */
public data class ApplicationGatewayFirewallExclusionResponse(
    public val matchVariable: String,
    public val selector: String,
    public val selectorMatchOperator: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayFirewallExclusionResponse): ApplicationGatewayFirewallExclusionResponse = ApplicationGatewayFirewallExclusionResponse(
            matchVariable = javaType.matchVariable(),
            selector = javaType.selector(),
            selectorMatchOperator = javaType.selectorMatchOperator(),
        )
    }
}
