@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Frontend port of an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the frontend port that is unique within an Application Gateway.
 * @property port Frontend port.
 * @property provisioningState The provisioning state of the frontend port resource.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayFrontendPortResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val port: Int? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayFrontendPortResponse): ApplicationGatewayFrontendPortResponse = ApplicationGatewayFrontendPortResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
