@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Application Gateway global configuration.
 * @property enableRequestBuffering Enable request buffering.
 * @property enableResponseBuffering Enable response buffering.
 */
public data class ApplicationGatewayGlobalConfigurationResponse(
    public val enableRequestBuffering: Boolean? = null,
    public val enableResponseBuffering: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayGlobalConfigurationResponse): ApplicationGatewayGlobalConfigurationResponse =
            ApplicationGatewayGlobalConfigurationResponse(
                enableRequestBuffering = javaType.enableRequestBuffering().map({ args0 -> args0 }).orElse(null),
                enableResponseBuffering = javaType.enableResponseBuffering().map({ args0 -> args0 }).orElse(null),
            )
    }
}
