@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the IP configuration that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the application gateway IP configuration resource.
 * @property subnet Reference to the subnet resource. A subnet from where application gateway gets its private address.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayIPConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val subnet: SubResourceResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayIPConfigurationResponse): ApplicationGatewayIPConfigurationResponse = ApplicationGatewayIPConfigurationResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
