@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Load Distribution Target of an application gateway.
 * @property backendAddressPool Backend address pool resource of the application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the load distribution policy that is unique within an Application Gateway.
 * @property type Type of the resource.
 * @property weightPerServer Weight per server. Range between 1 and 100.
 */
public data class ApplicationGatewayLoadDistributionTargetResponse(
    public val backendAddressPool: SubResourceResponse? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val type: String,
    public val weightPerServer: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayLoadDistributionTargetResponse): ApplicationGatewayLoadDistributionTargetResponse =
            ApplicationGatewayLoadDistributionTargetResponse(
                backendAddressPool = javaType.backendAddressPool().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
                weightPerServer = javaType.weightPerServer().map({ args0 -> args0 }).orElse(null),
            )
    }
}
