@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Path rule of URL path map of an application gateway.
 * @property backendAddressPool Backend address pool resource of URL path map path rule.
 * @property backendHttpSettings Backend http settings resource of URL path map path rule.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property firewallPolicy Reference to the FirewallPolicy resource.
 * @property id Resource ID.
 * @property loadDistributionPolicy Load Distribution Policy resource of URL path map path rule.
 * @property name Name of the path rule that is unique within an Application Gateway.
 * @property paths Path rules of URL path map.
 * @property provisioningState The provisioning state of the path rule resource.
 * @property redirectConfiguration Redirect configuration resource of URL path map path rule.
 * @property rewriteRuleSet Rewrite rule set resource of URL path map path rule.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayPathRuleResponse(
    public val backendAddressPool: SubResourceResponse? = null,
    public val backendHttpSettings: SubResourceResponse? = null,
    public val etag: String,
    public val firewallPolicy: SubResourceResponse? = null,
    public val id: String? = null,
    public val loadDistributionPolicy: SubResourceResponse? = null,
    public val name: String? = null,
    public val paths: List<String>? = null,
    public val provisioningState: String,
    public val redirectConfiguration: SubResourceResponse? = null,
    public val rewriteRuleSet: SubResourceResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayPathRuleResponse): ApplicationGatewayPathRuleResponse = ApplicationGatewayPathRuleResponse(
            backendAddressPool = javaType.backendAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            backendHttpSettings = javaType.backendHttpSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            firewallPolicy = javaType.firewallPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            loadDistributionPolicy = javaType.loadDistributionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            paths = javaType.paths().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            redirectConfiguration = javaType.redirectConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rewriteRuleSet = javaType.rewriteRuleSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
