@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Private Link Configuration on an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipConfigurations An array of application gateway private link ip configurations.
 * @property name Name of the private link configuration that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the application gateway private link configuration.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayPrivateLinkConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val ipConfigurations: List<ApplicationGatewayPrivateLinkIpConfigurationResponse>? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayPrivateLinkConfigurationResponse): ApplicationGatewayPrivateLinkConfigurationResponse =
            ApplicationGatewayPrivateLinkConfigurationResponse(
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayPrivateLinkIpConfigurationResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
