@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The application gateway private link ip configuration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of application gateway private link ip configuration.
 * @property primary Whether the ip configuration is primary or not.
 * @property privateIPAddress The private IP address of the IP configuration.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property provisioningState The provisioning state of the application gateway private link IP configuration.
 * @property subnet Reference to the subnet resource.
 * @property type The resource type.
 */
public data class ApplicationGatewayPrivateLinkIpConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val primary: Boolean? = null,
    public val privateIPAddress: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val provisioningState: String,
    public val subnet: SubResourceResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayPrivateLinkIpConfigurationResponse): ApplicationGatewayPrivateLinkIpConfigurationResponse =
            ApplicationGatewayPrivateLinkIpConfigurationResponse(
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
                privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
                privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                    args0
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
                subnet = javaType.subnet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
