@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Set of conditions in the Rewrite Rule in Application Gateway.
 * @property ignoreCase Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
 * @property negate Setting this value as truth will force to check the negation of the condition given by the user.
 * @property pattern The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
 * @property variable The condition parameter of the RewriteRuleCondition.
 */
public data class ApplicationGatewayRewriteRuleConditionResponse(
    public val ignoreCase: Boolean? = null,
    public val negate: Boolean? = null,
    public val pattern: String? = null,
    public val variable: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayRewriteRuleConditionResponse): ApplicationGatewayRewriteRuleConditionResponse =
            ApplicationGatewayRewriteRuleConditionResponse(
                ignoreCase = javaType.ignoreCase().map({ args0 -> args0 }).orElse(null),
                negate = javaType.negate().map({ args0 -> args0 }).orElse(null),
                pattern = javaType.pattern().map({ args0 -> args0 }).orElse(null),
                variable = javaType.variable().map({ args0 -> args0 }).orElse(null),
            )
    }
}
