@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rewrite rule of an application gateway.
 * @property actionSet Set of actions to be done as part of the rewrite Rule.
 * @property conditions Conditions based on which the action set execution will be evaluated.
 * @property name Name of the rewrite rule that is unique within an Application Gateway.
 * @property ruleSequence Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
 */
public data class ApplicationGatewayRewriteRuleResponse(
    public val actionSet: ApplicationGatewayRewriteRuleActionSetResponse? = null,
    public val conditions: List<ApplicationGatewayRewriteRuleConditionResponse>? = null,
    public val name: String? = null,
    public val ruleSequence: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayRewriteRuleResponse): ApplicationGatewayRewriteRuleResponse = ApplicationGatewayRewriteRuleResponse(
            actionSet = javaType.actionSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRewriteRuleActionSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRewriteRuleConditionResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ruleSequence = javaType.ruleSequence().map({ args0 -> args0 }).orElse(null),
        )
    }
}
