@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rewrite rule set of an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the rewrite rule set that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the rewrite rule set resource.
 * @property rewriteRules Rewrite rules in the rewrite rule set.
 */
public data class ApplicationGatewayRewriteRuleSetResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val rewriteRules: List<ApplicationGatewayRewriteRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayRewriteRuleSetResponse): ApplicationGatewayRewriteRuleSetResponse = ApplicationGatewayRewriteRuleSetResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            rewriteRules = javaType.rewriteRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRewriteRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
