@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Application Gateway Ssl policy.
 * @property cipherSuites Ssl cipher suites to be enabled in the specified order to application gateway.
 * @property disabledSslProtocols Ssl protocols to be disabled on application gateway.
 * @property minProtocolVersion Minimum version of Ssl protocol to be supported on application gateway.
 * @property policyName Name of Ssl predefined policy.
 * @property policyType Type of Ssl Policy.
 */
public data class ApplicationGatewaySslPolicyResponse(
    public val cipherSuites: List<String>? = null,
    public val disabledSslProtocols: List<String>? = null,
    public val minProtocolVersion: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewaySslPolicyResponse): ApplicationGatewaySslPolicyResponse = ApplicationGatewaySslPolicyResponse(
            cipherSuites = javaType.cipherSuites().map({ args0 -> args0 }),
            disabledSslProtocols = javaType.disabledSslProtocols().map({ args0 -> args0 }),
            minProtocolVersion = javaType.minProtocolVersion().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
