@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Trusted client certificates of an application gateway.
 * @property clientCertIssuerDN Distinguished name of client certificate issuer.
 * @property data Certificate public data.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the trusted client certificate that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the trusted client certificate resource.
 * @property type Type of the resource.
 * @property validatedCertData Validated certificate data.
 */
public data class ApplicationGatewayTrustedClientCertificateResponse(
    public val clientCertIssuerDN: String,
    public val `data`: String? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
    public val validatedCertData: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayTrustedClientCertificateResponse): ApplicationGatewayTrustedClientCertificateResponse =
            ApplicationGatewayTrustedClientCertificateResponse(
                clientCertIssuerDN = javaType.clientCertIssuerDN(),
                `data` = javaType.`data`().map({ args0 -> args0 }).orElse(null),
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
                validatedCertData = javaType.validatedCertData(),
            )
    }
}
