@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Url configuration of the Actions set in Application Gateway.
 * @property modifiedPath Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
 * @property modifiedQueryString Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
 * @property reroute If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
 */
public data class ApplicationGatewayUrlConfigurationResponse(
    public val modifiedPath: String? = null,
    public val modifiedQueryString: String? = null,
    public val reroute: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayUrlConfigurationResponse): ApplicationGatewayUrlConfigurationResponse = ApplicationGatewayUrlConfigurationResponse(
            modifiedPath = javaType.modifiedPath().map({ args0 -> args0 }).orElse(null),
            modifiedQueryString = javaType.modifiedQueryString().map({ args0 -> args0 }).orElse(null),
            reroute = javaType.reroute().map({ args0 -> args0 }).orElse(null),
        )
    }
}
