@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
 * @property defaultBackendAddressPool Default backend address pool resource of URL path map.
 * @property defaultBackendHttpSettings Default backend http settings resource of URL path map.
 * @property defaultLoadDistributionPolicy Default Load Distribution Policy resource of URL path map.
 * @property defaultRedirectConfiguration Default redirect configuration resource of URL path map.
 * @property defaultRewriteRuleSet Default Rewrite rule set resource of URL path map.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the URL path map that is unique within an Application Gateway.
 * @property pathRules Path rule of URL path map resource.
 * @property provisioningState The provisioning state of the URL path map resource.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayUrlPathMapResponse(
    public val defaultBackendAddressPool: SubResourceResponse? = null,
    public val defaultBackendHttpSettings: SubResourceResponse? = null,
    public val defaultLoadDistributionPolicy: SubResourceResponse? = null,
    public val defaultRedirectConfiguration: SubResourceResponse? = null,
    public val defaultRewriteRuleSet: SubResourceResponse? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val pathRules: List<ApplicationGatewayPathRuleResponse>? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayUrlPathMapResponse): ApplicationGatewayUrlPathMapResponse = ApplicationGatewayUrlPathMapResponse(
            defaultBackendAddressPool = javaType.defaultBackendAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultBackendHttpSettings = javaType.defaultBackendHttpSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultLoadDistributionPolicy = javaType.defaultLoadDistributionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultRedirectConfiguration = javaType.defaultRedirectConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultRewriteRuleSet = javaType.defaultRewriteRuleSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            pathRules = javaType.pathRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayPathRuleResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
