@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Application gateway web application firewall configuration.
 * @property disabledRuleGroups The disabled rule groups.
 * @property enabled Whether the web application firewall is enabled or not.
 * @property exclusions The exclusion list.
 * @property fileUploadLimitInMb Maximum file upload size in Mb for WAF.
 * @property firewallMode Web application firewall mode.
 * @property maxRequestBodySize Maximum request body size for WAF.
 * @property maxRequestBodySizeInKb Maximum request body size in Kb for WAF.
 * @property requestBodyCheck Whether allow WAF to check request Body.
 * @property ruleSetType The type of the web application firewall rule set. Possible values are: 'OWASP'.
 * @property ruleSetVersion The version of the rule set type.
 */
public data class ApplicationGatewayWebApplicationFirewallConfigurationResponse(
    public val disabledRuleGroups: List<ApplicationGatewayFirewallDisabledRuleGroupResponse>? = null,
    public val enabled: Boolean,
    public val exclusions: List<ApplicationGatewayFirewallExclusionResponse>? = null,
    public val fileUploadLimitInMb: Int? = null,
    public val firewallMode: String,
    public val maxRequestBodySize: Int? = null,
    public val maxRequestBodySizeInKb: Int? = null,
    public val requestBodyCheck: Boolean? = null,
    public val ruleSetType: String,
    public val ruleSetVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayWebApplicationFirewallConfigurationResponse): ApplicationGatewayWebApplicationFirewallConfigurationResponse =
            ApplicationGatewayWebApplicationFirewallConfigurationResponse(
                disabledRuleGroups = javaType.disabledRuleGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayFirewallDisabledRuleGroupResponse.Companion.toKotlin(args0)
                    })
                }),
                enabled = javaType.enabled(),
                exclusions = javaType.exclusions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayFirewallExclusionResponse.Companion.toKotlin(args0)
                    })
                }),
                fileUploadLimitInMb = javaType.fileUploadLimitInMb().map({ args0 -> args0 }).orElse(null),
                firewallMode = javaType.firewallMode(),
                maxRequestBodySize = javaType.maxRequestBodySize().map({ args0 -> args0 }).orElse(null),
                maxRequestBodySizeInKb = javaType.maxRequestBodySizeInKb().map({ args0 -> args0 }).orElse(null),
                requestBodyCheck = javaType.requestBodyCheck().map({ args0 -> args0 }).orElse(null),
                ruleSetType = javaType.ruleSetType(),
                ruleSetVersion = javaType.ruleSetVersion(),
            )
    }
}
