@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of an application rule.
 * @property description Description of the rule.
 * @property fqdnTags List of FQDN Tags for this rule.
 * @property name Name of the application rule.
 * @property protocols Array of ApplicationRuleProtocols.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property targetFqdns List of FQDNs for this rule.
 */
public data class AzureFirewallApplicationRuleResponse(
    public val description: String? = null,
    public val fqdnTags: List<String>? = null,
    public val name: String? = null,
    public val protocols: List<AzureFirewallApplicationRuleProtocolResponse>? = null,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
    public val targetFqdns: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallApplicationRuleResponse): AzureFirewallApplicationRuleResponse = AzureFirewallApplicationRuleResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fqdnTags = javaType.fqdnTags().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocols = javaType.protocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallApplicationRuleProtocolResponse.Companion.toKotlin(args0)
                })
            }),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
            targetFqdns = javaType.targetFqdns().map({ args0 -> args0 }),
        )
    }
}
