@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IpGroups associated with azure firewall.
 * @property changeNumber The iteration number.
 * @property id Resource ID.
 */
public data class AzureFirewallIpGroupsResponse(
    public val changeNumber: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallIpGroupsResponse): AzureFirewallIpGroupsResponse = AzureFirewallIpGroupsResponse(
            changeNumber = javaType.changeNumber(),
            id = javaType.id(),
        )
    }
}
