@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Public IP Address associated with azure firewall.
 * @property address Public IP Address value.
 */
public data class AzureFirewallPublicIPAddressResponse(
    public val address: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallPublicIPAddressResponse): AzureFirewallPublicIPAddressResponse = AzureFirewallPublicIPAddressResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
        )
    }
}
