@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Pool of backend IP addresses.
 * @property backendIPConfigurations An array of references to IP addresses defined in network interfaces.
 * @property drainPeriodInSeconds Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property inboundNatRules An array of references to inbound NAT rules that use this backend address pool.
 * @property loadBalancerBackendAddresses An array of backend addresses.
 * @property loadBalancingRules An array of references to load balancing rules that use this backend address pool.
 * @property location The location of the backend address pool.
 * @property name The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
 * @property outboundRule A reference to an outbound rule that uses this backend address pool.
 * @property outboundRules An array of references to outbound rules that use this backend address pool.
 * @property provisioningState The provisioning state of the backend address pool resource.
 * @property tunnelInterfaces An array of gateway load balancer tunnel interfaces.
 * @property type Type of the resource.
 * @property virtualNetwork A reference to a virtual network.
 */
public data class BackendAddressPoolResponse(
    public val backendIPConfigurations: List<NetworkInterfaceIPConfigurationResponse>,
    public val drainPeriodInSeconds: Int? = null,
    public val etag: String,
    public val id: String? = null,
    public val inboundNatRules: List<SubResourceResponse>,
    public val loadBalancerBackendAddresses: List<LoadBalancerBackendAddressResponse>? = null,
    public val loadBalancingRules: List<SubResourceResponse>,
    public val location: String? = null,
    public val name: String? = null,
    public val outboundRule: SubResourceResponse,
    public val outboundRules: List<SubResourceResponse>,
    public val provisioningState: String,
    public val tunnelInterfaces: List<GatewayLoadBalancerTunnelInterfaceResponse>? = null,
    public val type: String,
    public val virtualNetwork: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BackendAddressPoolResponse): BackendAddressPoolResponse = BackendAddressPoolResponse(
            backendIPConfigurations = javaType.backendIPConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            drainPeriodInSeconds = javaType.drainPeriodInSeconds().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            inboundNatRules = javaType.inboundNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancerBackendAddresses = javaType.loadBalancerBackendAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.LoadBalancerBackendAddressResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancingRules = javaType.loadBalancingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            outboundRule = javaType.outboundRule().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            outboundRules = javaType.outboundRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            tunnelInterfaces = javaType.tunnelInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.GatewayLoadBalancerTunnelInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            virtualNetwork = javaType.virtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
