@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A backend pool is a collection of backends that can be routed to.
 * @property backends The set of backends for this pool
 * @property healthProbeSettings L7 health probe settings for a backend pool
 * @property id Resource ID.
 * @property loadBalancingSettings Load balancing settings for a backend pool
 * @property name Resource name.
 * @property resourceState Resource status.
 * @property type Resource type.
 */
public data class BackendPoolResponse(
    public val backends: List<BackendResponse>? = null,
    public val healthProbeSettings: SubResourceResponse? = null,
    public val id: String? = null,
    public val loadBalancingSettings: SubResourceResponse? = null,
    public val name: String? = null,
    public val resourceState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BackendPoolResponse): BackendPoolResponse = BackendPoolResponse(
            backends = javaType.backends().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BackendResponse.Companion.toKotlin(args0)
                })
            }),
            healthProbeSettings = javaType.healthProbeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            loadBalancingSettings = javaType.loadBalancingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            resourceState = javaType.resourceState(),
            type = javaType.type(),
        )
    }
}
