@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The session detail for a target.
 * @property protocol The protocol used to connect to the target.
 * @property resourceType The type of the resource.
 * @property sessionDurationInMins Duration in mins the session has been active.
 * @property sessionId A unique id for the session.
 * @property startTime The time when the session started.
 * @property targetHostName The host name of the target.
 * @property targetIpAddress The IP Address of the target.
 * @property targetResourceGroup The resource group of the target.
 * @property targetResourceId The resource id of the target.
 * @property targetSubscriptionId The subscription id for the target virtual machine.
 * @property userName The user name who is active on this session.
 */
public data class BastionActiveSessionResponse(
    public val protocol: String,
    public val resourceType: String,
    public val sessionDurationInMins: Double,
    public val sessionId: String,
    public val startTime: Any,
    public val targetHostName: String,
    public val targetIpAddress: String,
    public val targetResourceGroup: String,
    public val targetResourceId: String,
    public val targetSubscriptionId: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BastionActiveSessionResponse): BastionActiveSessionResponse = BastionActiveSessionResponse(
            protocol = javaType.protocol(),
            resourceType = javaType.resourceType(),
            sessionDurationInMins = javaType.sessionDurationInMins(),
            sessionId = javaType.sessionId(),
            startTime = javaType.startTime(),
            targetHostName = javaType.targetHostName(),
            targetIpAddress = javaType.targetIpAddress(),
            targetResourceGroup = javaType.targetResourceGroup(),
            targetResourceId = javaType.targetResourceId(),
            targetSubscriptionId = javaType.targetSubscriptionId(),
            userName = javaType.userName(),
        )
    }
}
