@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * BGP settings details.
 * @property asn The BGP speaker's ASN.
 * @property bgpPeeringAddress The BGP peering address and BGP identifier of this BGP speaker.
 * @property bgpPeeringAddresses BGP peering address with IP configuration ID for virtual network gateway.
 * @property peerWeight The weight added to routes learned from this BGP speaker.
 */
public data class BgpSettingsResponse(
    public val asn: Double? = null,
    public val bgpPeeringAddress: String? = null,
    public val bgpPeeringAddresses: List<IPConfigurationBgpPeeringAddressResponse>? = null,
    public val peerWeight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BgpSettingsResponse): BgpSettingsResponse = BgpSettingsResponse(
            asn = javaType.asn().map({ args0 -> args0 }).orElse(null),
            bgpPeeringAddress = javaType.bgpPeeringAddress().map({ args0 -> args0 }).orElse(null),
            bgpPeeringAddresses = javaType.bgpPeeringAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationBgpPeeringAddressResponse.Companion.toKotlin(args0)
                })
            }),
            peerWeight = javaType.peerWeight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
