@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
 * @property cacheDuration The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
 * @property dynamicCompression Whether to use dynamic compression for cached content
 * @property queryParameterStripDirective Treatment of URL query terms when forming the cache key.
 * @property queryParameters query parameters to include or exclude (comma separated).
 */
public data class CacheConfigurationResponse(
    public val cacheDuration: String? = null,
    public val dynamicCompression: String? = null,
    public val queryParameterStripDirective: String? = null,
    public val queryParameters: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.CacheConfigurationResponse): CacheConfigurationResponse = CacheConfigurationResponse(
            cacheDuration = javaType.cacheDuration().map({ args0 -> args0 }).orElse(null),
            dynamicCompression = javaType.dynamicCompression().map({ args0 -> args0 }).orElse(null),
            queryParameterStripDirective = javaType.queryParameterStripDirective().map({ args0 ->
                args0
            }).orElse(null),
            queryParameters = javaType.queryParameters().map({ args0 -> args0 }).orElse(null),
        )
    }
}
