@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the destination of connection monitor.
 * @property address Address of the connection monitor destination (IP or domain name).
 * @property port The destination port used by connection monitor.
 * @property resourceId The ID of the resource used as the destination by connection monitor.
 */
public data class ConnectionMonitorDestinationResponse(
    public val address: String? = null,
    public val port: Int? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorDestinationResponse): ConnectionMonitorDestinationResponse = ConnectionMonitorDestinationResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
