@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the connection monitor endpoint filter item.
 * @property address The address of the filter item.
 * @property type The type of item included in the filter. Currently only 'AgentAddress' is supported.
 */
public data class ConnectionMonitorEndpointFilterItemResponse(
    public val address: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorEndpointFilterItemResponse): ConnectionMonitorEndpointFilterItemResponse = ConnectionMonitorEndpointFilterItemResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
