@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the connection monitor endpoint filter.
 * @property items List of items in the filter.
 * @property type The behavior of the endpoint filter. Currently only 'Include' is supported.
 */
public data class ConnectionMonitorEndpointFilterResponse(
    public val items: List<ConnectionMonitorEndpointFilterItemResponse>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorEndpointFilterResponse): ConnectionMonitorEndpointFilterResponse = ConnectionMonitorEndpointFilterResponse(
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointFilterItemResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
