@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the connection monitor endpoint scope item.
 * @property address The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
 */
public data class ConnectionMonitorEndpointScopeItemResponse(
    public val address: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorEndpointScopeItemResponse): ConnectionMonitorEndpointScopeItemResponse = ConnectionMonitorEndpointScopeItemResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
        )
    }
}
