@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a connection monitor output destination.
 * @property type Connection monitor output destination type. Currently, only "Workspace" is supported.
 * @property workspaceSettings Describes the settings for producing output into a log analytics workspace.
 */
public data class ConnectionMonitorOutputResponse(
    public val type: String? = null,
    public val workspaceSettings: ConnectionMonitorWorkspaceSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorOutputResponse): ConnectionMonitorOutputResponse = ConnectionMonitorOutputResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            workspaceSettings = javaType.workspaceSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorWorkspaceSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
