@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Describes the threshold for declaring a test successful.
 * @property checksFailedPercent The maximum percentage of failed checks permitted for a test to evaluate as successful.
 * @property roundTripTimeMs The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
 */
public data class ConnectionMonitorSuccessThresholdResponse(
    public val checksFailedPercent: Int? = null,
    public val roundTripTimeMs: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorSuccessThresholdResponse): ConnectionMonitorSuccessThresholdResponse = ConnectionMonitorSuccessThresholdResponse(
            checksFailedPercent = javaType.checksFailedPercent().map({ args0 -> args0 }).orElse(null),
            roundTripTimeMs = javaType.roundTripTimeMs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
