@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the TCP configuration.
 * @property destinationPortBehavior Destination port behavior.
 * @property disableTraceRoute Value indicating whether path evaluation with trace route should be disabled.
 * @property port The port to connect to.
 */
public data class ConnectionMonitorTcpConfigurationResponse(
    public val destinationPortBehavior: String? = null,
    public val disableTraceRoute: Boolean? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorTcpConfigurationResponse): ConnectionMonitorTcpConfigurationResponse = ConnectionMonitorTcpConfigurationResponse(
            destinationPortBehavior = javaType.destinationPortBehavior().map({ args0 -> args0 }).orElse(null),
            disableTraceRoute = javaType.disableTraceRoute().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
