@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connectivity group item.
 * @property groupConnectivity Group connectivity type.
 * @property isGlobal Flag if global is supported.
 * @property networkGroupId Network group Id.
 * @property useHubGateway Flag if need to use hub gateway.
 */
public data class ConnectivityGroupItemResponse(
    public val groupConnectivity: String,
    public val isGlobal: String? = null,
    public val networkGroupId: String,
    public val useHubGateway: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectivityGroupItemResponse): ConnectivityGroupItemResponse = ConnectivityGroupItemResponse(
            groupConnectivity = javaType.groupConnectivity(),
            isGlobal = javaType.isGlobal().map({ args0 -> args0 }).orElse(null),
            networkGroupId = javaType.networkGroupId(),
            useHubGateway = javaType.useHubGateway().map({ args0 -> args0 }).orElse(null),
        )
    }
}
