@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container network interface configuration child resource.
 * @property containerNetworkInterfaces A list of container network interfaces created from this container network interface configuration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipConfigurations A list of ip configurations of the container network interface configuration.
 * @property name The name of the resource. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the container network interface configuration resource.
 * @property type Sub Resource type.
 */
public data class ContainerNetworkInterfaceConfigurationResponse(
    public val containerNetworkInterfaces: List<SubResourceResponse>? = null,
    public val etag: String,
    public val id: String? = null,
    public val ipConfigurations: List<IPConfigurationProfileResponse>? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ContainerNetworkInterfaceConfigurationResponse): ContainerNetworkInterfaceConfigurationResponse =
            ContainerNetworkInterfaceConfigurationResponse(
                containerNetworkInterfaces = javaType.containerNetworkInterfaces().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationProfileResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
