@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The ip configuration for a container network interface.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property name The name of the resource. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the container network interface IP configuration resource.
 * @property type Sub Resource type.
 */
public data class ContainerNetworkInterfaceIpConfigurationResponse(
    public val etag: String,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ContainerNetworkInterfaceIpConfigurationResponse): ContainerNetworkInterfaceIpConfigurationResponse =
            ContainerNetworkInterfaceIpConfigurationResponse(
                etag = javaType.etag(),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
