@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A matching criteria which matches routes based on route prefix, community, and AS path.
 * @property asPath List of AS paths which this criteria matches.
 * @property community List of BGP communities which this criteria matches.
 * @property matchCondition Match condition to apply RouteMap rules.
 * @property routePrefix List of route prefixes which this criteria matches.
 */
public data class CriterionResponse(
    public val asPath: List<String>? = null,
    public val community: List<String>? = null,
    public val matchCondition: String? = null,
    public val routePrefix: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.CriterionResponse): CriterionResponse = CriterionResponse(
            asPath = javaType.asPath().map({ args0 -> args0 }),
            community = javaType.community().map({ args0 -> args0 }),
            matchCondition = javaType.matchCondition().map({ args0 -> args0 }).orElse(null),
            routePrefix = javaType.routePrefix().map({ args0 -> args0 }),
        )
    }
}
