@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contains custom Dns resolution configuration from customer.
 * @property fqdn Fqdn that resolves to private endpoint ip address.
 * @property ipAddresses A list of private ip addresses of the private endpoint.
 */
public data class CustomDnsConfigPropertiesFormatResponse(
    public val fqdn: String? = null,
    public val ipAddresses: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.CustomDnsConfigPropertiesFormatResponse): CustomDnsConfigPropertiesFormatResponse = CustomDnsConfigPropertiesFormatResponse(
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
        )
    }
}
