@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Https settings for a domain
 * @property certificateSource Defines the source of the SSL certificate
 * @property certificateType Defines the type of the certificate used for secure connections to a frontendEndpoint
 * @property minimumTlsVersion The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
 * @property protocolType Defines the TLS extension protocol that is used for secure delivery
 * @property secretName The name of the Key Vault secret representing the full certificate PFX
 * @property secretVersion The version of the Key Vault secret representing the full certificate PFX
 * @property vault The Key Vault containing the SSL certificate
 */
public data class CustomHttpsConfigurationResponse(
    public val certificateSource: String,
    public val certificateType: String? = null,
    public val minimumTlsVersion: String,
    public val protocolType: String,
    public val secretName: String? = null,
    public val secretVersion: String? = null,
    public val vault: KeyVaultCertificateSourceParametersResponseVault? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.CustomHttpsConfigurationResponse): CustomHttpsConfigurationResponse = CustomHttpsConfigurationResponse(
            certificateSource = javaType.certificateSource(),
            certificateType = javaType.certificateType().map({ args0 -> args0 }).orElse(null),
            minimumTlsVersion = javaType.minimumTlsVersion(),
            protocolType = javaType.protocolType(),
            secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
            secretVersion = javaType.secretVersion().map({ args0 -> args0 }).orElse(null),
            vault = javaType.vault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.KeyVaultCertificateSourceParametersResponseVault.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
