@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the delegation.
 * @property provisioningState The current provisioning state.
 * @property serviceName The service name to which the NVA is delegated.
 */
public data class DelegationPropertiesResponse(
    public val provisioningState: String,
    public val serviceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.DelegationPropertiesResponse): DelegationPropertiesResponse = DelegationPropertiesResponse(
            provisioningState = javaType.provisioningState(),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
