@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details the service to which the subnet is delegated.
 * @property actions The actions permitted to the service upon delegation.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a subnet. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the service delegation resource.
 * @property serviceName The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
 * @property type Resource type.
 */
public data class DelegationResponse(
    public val actions: List<String>,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val serviceName: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.DelegationResponse): DelegationResponse = DelegationResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
