@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * List of properties of the device.
 * @property deviceModel Model of the device.
 * @property deviceVendor Name of the device Vendor.
 * @property linkSpeedInMbps Link speed.
 */
public data class DevicePropertiesResponse(
    public val deviceModel: String? = null,
    public val deviceVendor: String? = null,
    public val linkSpeedInMbps: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.DevicePropertiesResponse): DevicePropertiesResponse = DevicePropertiesResponse(
            deviceModel = javaType.deviceModel().map({ args0 -> args0 }).orElse(null),
            deviceVendor = javaType.deviceVendor().map({ args0 -> args0 }).orElse(null),
            linkSpeedInMbps = javaType.linkSpeedInMbps().map({ args0 -> args0 }).orElse(null),
        )
    }
}
