@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Class containing DNS settings in a Traffic Manager profile.
 * @property fqdn The fully-qualified domain name (FQDN) of the Traffic Manager profile. This is formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic Manager.
 * @property relativeName The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
 * @property ttl The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
 */
public data class DnsConfigResponse(
    public val fqdn: String,
    public val relativeName: String? = null,
    public val ttl: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.DnsConfigResponse): DnsConfigResponse = DnsConfigResponse(
            fqdn = javaType.fqdn(),
            relativeName = javaType.relativeName().map({ args0 -> args0 }).orElse(null),
            ttl = javaType.ttl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
