@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DNS Proxy Settings in Firewall Policy.
 * @property enableProxy Enable DNS Proxy on Firewalls attached to the Firewall Policy.
 * @property requireProxyForNetworkRules FQDNs in Network Rules are supported when set to true.
 * @property servers List of Custom DNS Servers.
 */
public data class DnsSettingsResponse(
    public val enableProxy: Boolean? = null,
    public val requireProxyForNetworkRules: Boolean? = null,
    public val servers: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.DnsSettingsResponse): DnsSettingsResponse = DnsSettingsResponse(
            enableProxy = javaType.enableProxy().map({ args0 -> args0 }).orElse(null),
            requireProxyForNetworkRules = javaType.requireProxyForNetworkRules().map({ args0 ->
                args0
            }).orElse(null),
            servers = javaType.servers().map({ args0 -> args0 }),
        )
    }
}
