@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The network manager effective connectivity configuration
 * @property appliesToGroups Groups for configuration
 * @property configurationGroups Effective configuration groups.
 * @property connectivityTopology Connectivity topology type.
 * @property deleteExistingPeering Flag if need to remove current existing peerings.
 * @property description A description of the connectivity configuration.
 * @property displayName A friendly name for the resource.
 * @property hubs List of hubItems
 * @property id Connectivity configuration ID.
 * @property isGlobal Flag if global mesh is supported.
 * @property provisioningState The provisioning state of the connectivity configuration resource.
 * @property resourceGuid Unique identifier for this resource.
 */
public data class EffectiveConnectivityConfigurationResponse(
    public val appliesToGroups: List<ConnectivityGroupItemResponse>,
    public val configurationGroups: List<ConfigurationGroupResponse>? = null,
    public val connectivityTopology: String,
    public val deleteExistingPeering: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val hubs: List<HubResponse>? = null,
    public val id: String? = null,
    public val isGlobal: String? = null,
    public val provisioningState: String,
    public val resourceGuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.EffectiveConnectivityConfigurationResponse): EffectiveConnectivityConfigurationResponse = EffectiveConnectivityConfigurationResponse(
            appliesToGroups = javaType.appliesToGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectivityGroupItemResponse.Companion.toKotlin(args0)
                })
            }),
            configurationGroups = javaType.configurationGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConfigurationGroupResponse.Companion.toKotlin(args0)
                })
            }),
            connectivityTopology = javaType.connectivityTopology(),
            deleteExistingPeering = javaType.deleteExistingPeering().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            hubs = javaType.hubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HubResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isGlobal = javaType.isGlobal().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
        )
    }
}
